# Setting Up The Server #
This section will walk you through how to setup the UI environment on the server.

### Update Yum
`sudo yum update`

### Install NodeJS
`sudo curl --silent --location https://rpm.nodesource.com/setup_4.x | bash -`

If the RPM install fails you will have to run it manually. The command will be displayed on the screen and it looks something like this: `sudo rpm -i --nosignature --force '/tmp/tmp.TDULoz0MUE'`

Now we have to install the nodejs that we downloaded: `sudo yum -y install nodejs`

### Install GIT
`sudo yum install git`

### Install NGINX
`sudo yum install nginx.x86_64`

### Clone the Repo
`PII`

### Install Grunt Command Line Globally For Development
Run `sudo npm install grunt@0.4.5 -g`

Run `sudo npm install grunt-cli -g`

Test to make sure grunt is working by typing in `grunt --version`

### Install the Project for Deployment
Run `npm run build` then copy the contents of the dist folder to the web
server's root www directory.

### Install the Project For Development
Clone the repo then run the following command: `sudo npm install --dev`

### Build the Project For Deployment
Copy one of the files from the env folder into the dist/js folder and
rename it env.js. Update the contents of the env.js file to match the locations
of the API endpoint and the location of the help file.

### Build the Project For Development
Clone the repository and run `npm install --dev`. When the installation is
complete you can build the project for a specific environment using the
following commands.

* Development Sustainment environment: `npm run dev-sustainment`
* Development Release environment: `npm run dev-release`
* Deployment to production environment (no dist/help/env.js file): `npm run build`

### Generate the dist/help/env.js file

Sometimes you just want to generate the environment configuration file without
running grunt or creating the rest of the files in the dist folder. You can do
this by running the following command: `npm run envfile`

### Update NGINX Root Directory
`sudo vi /etc/nginx/nginx.conf`

Change the line that says root to point to `opt/genisis/dist`

### Start NGINX
`sudo service nginx start`

# Developing Locally
This section will go over the typical development process for setting up and
running the UI project on your computer locally.

### Software Requirements
In order to develop locally you must have Node v4.5.0, GIT Bash, XAMPP and an IDE.
We also recommend using Console2 for multi window and tabbed viewing of the MINGW64
console you will be using.

### Install Node 4.5.0
A list of all the downloads for this version of node are available here: https://nodejs.org/download/release/v4.5.0/

Documentation for this version of node is available here: https://nodejs.org/download/release/v4.5.0/docs/api/

### Install GIT
Download the windows version which includes MINGW64 Bash program that you will
be using as your console: https://git-for-windows.github.io/

### Install Console 2
It's *strongly recommended* you install and use Console2, it will make developing with
the MINGW64 console a lot easier and less annoying than having lots of console
windows all over your desktop.

https://sourceforge.net/projects/console/

##### Configuration
Once you have Console2 installed you want to update it to use the MINGW64 bash provided
when you downloaded GIT.

1. Open the Console2 program.
2. Go to Edit > Settings.
3. In the settings window locate the Shell field
4. Enter: `C:\Windows\SysWOW64\cmd.exe  /c ""C:\Users\{USERID}\AppData\Local\Programs\Git\bin\sh.exe" --login -i"``
5. Replace {USERID} with your BAH 6 digit ID number (if you don't know it look for the folder in C:\Users)
6. In the Startup Directory field, enter: `C:\xampp\htdocs\genisis`
7. Click OK at the bottom of the settings window.
8. Restart Console2 once you have cloned the genisis project in the step below.

### Atom IDE Editor ###
It's *strongly recommended* you use the Atom IDE, however you can use whatever
IDE you like the most. There are several great plugins that work well with Atom
and make it easier to catch errors as your programming on the project.

You can download Atom here: https://atom.io/

### Install Atom Plugins
These are the recommended plugins that you install once you have Atom. To add a
new plugin first open Atom then go to File > Settings. Find the Install section
at the bottom of the left hand side of the settings menu and click on it. Enter
the following plugins into the package search box and then hit install when you
find them:

* atom-jasmine (by zacharytamas)
* csslint (by tcarlsen)
* grunt-runner (by kokarn)
* linter (by atom-community)
* linter-csslint (by AtomLinter)
* linter-htmlhint (by AtomLinter)
* linter-jshint (by AtomLinter)
* atom-wallaby (by wallabyjs)

*Note:* atom-wallaby requires a separate license purchase, it is
not required to get the project working, but it will help with writing unit tests
and will notify you immediately if something you do has broken a unit test and it
can provide code coverage reports for your unit tests. Buy a license here: https://wallabyjs.com/

Once you are done installing all of the plugins you need to restart Atom for to see
some of them in action. You can access all the plugin commands by pressing `Ctrl + Shift + P`
and then starting to type in the name of the plugin. Try typing Grunt or Wallaby.

### Install XAMPP
This will setup and install and allow you to easily manage a local Apache server that runs
on your computer as you develop and test the project. Download it here: https://www.apachefriends.org/download.html

## Download the Source Code
Before you can start any local development you need to get a copy of the project
source code.

### Create an SSH Key
You need an SSH key before you can get access to the code repo. Open Console2 and
in the command line type in the following:

`cd ~/.ssh/`

This changes you into the SSH directory. Now you need to generate your new SSH key.
When it prompts you, just keep hitting enter. Do not create a password and do not
change the name of the file it wants to generate.

`ssh-keygen`

Now if you display the contents of your .ssh folder you will see two new files,
one called id_rsa and the other called id_rsa.pub:

`ls -la`

### Add SSH Key ###
Now that you have an id_rsa and a .pub file you need to add this SSH key to the repo.
If you don't have access to the SSP to can request it here using project and team
name Genisis20: https://selfserviceportal.boozallencsn.com/ad

If you already have access to SSP then locate the SSH Keys on the left hand side
menu and enter the contents of your id_rsa.pub file into the input field and click
the add button. You can get the contents of your id_rsa.pub file by doing the following:

`cat ~/.ssh/id_rsa.pub`

Now you should have SSH access to the repo. If you want to see the files in the repo on
Github you can click on the Github link under the Genisis2Client project in SSP.

### Clone the Project ###
Open Console2, you will see the command line for the MINGW64 console if you did
the initial setup correctly. If you don't refer back to the section above.

Change into the XAMPP file system location. This will allow you to view your
files and changes when XAMPP is running:

`cd /c/xampp/htdocs`

Now clone the project into a genisis folder like so:
`git clone git@github.boozallencsn.com:HEALTH-ACCT-GROUP/Genisis2Client.git genisis`

## Setup the Project
This section will show you how to get the project setup once you've setup all of
your software and have cloned the project.

### Install NPM dependencies Project ###
Now that you've cloned the project you have to download all the dependencies and
generate the `dist` folder. In Console2 type the following:

`cd /c/xampp/htdocs/genisis`

This places you into the genisis folder where you cloned the project. Now you
install and build:

`npm install && grunt build`

This installs all the NPM dependencies and then does the initial build of the project.
You should now see a new dist folder has appeared. This is the folder that contains the
deployable version of the project.

### Start XAMPP Apache Server ###
Open the XAMPP executable program. You will see the XAMPP control panel. Click on
the start button for the APACHE web server.

### View Project In Browser ###
Once the XAMPP Apache server is running and you've initialize and built the project
you can view the project in your browser by going to the dist file that was generated:

http://localhost/dist

*Note:* If you're using an IDE like Atom or Sublime you will not see the dist folder in your file
tree because it is listed in the .gitignore configuration and by default these IDEs
remove those files from your file tree, however the file is there and available if you
navigate to it

# Typical Daily Development Process #

1. Start Apache on XAMPP
2. Open Console2 and go into your genisis directory: `cd /c/xampp/htdocs/genisis`
3. Run the development environment and start grunt: `npm run watch`
4. Make changes to the code in the `src` folder
5. Check the console output results from grunt watch (or IDE plugin) for any errors
6. Fix any errors or breaking unit tests
7. Test your changes in the browser when the tests run clean by going to: http://localhost/dist

# Testing API - Postman Tests #

If you would like to run some simple API tests that were developed in Postman
you can enter the following command from the root directory: `newman run postman_tests.json`
For the full list of Newman options you can consult the documentation here: https://github.com/postmanlabs/newman

### Generating Postman HTML Output ###

If you would like to see HTML version of the Newman output you can run the following and
a new folder called Newman will be created with the results of your test runs:
`newman run postman_tests.json --reporters html`

### Generating Postman CLI Output ###

If you want to get results from the postman test to see in the command line if the
tests have succeeded or failed you can run the following: `newman run postman_tests.json --reporter-cli-no-summary --reporter-cli-no-console --reporter-cli-no-assertions`
happy coding
